﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.BAL
{


    [DataObjectAttribute()]
    public static class OrdersBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static Orders GetItem(Guid ordersID, Guid userAccountID, string keyword, DateTime fromDate, DateTime toDate)
        {
            return OrdersDB.GetItem(ordersID, userAccountID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword), fromDate, toDate);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<Orders> GetList(Guid ordersID, Guid userAccountID, string keyword, DateTime fromDate, DateTime toDate)
        {
            return OrdersDB.GetList(ordersID, userAccountID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword), fromDate, toDate);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<Orders> GetOfflineList(Guid ordersID, Guid userAccountID, string keyword, DateTime fromDate, DateTime toDate)
        {
            return OrdersDB.GetOfflineList(ordersID, userAccountID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword), fromDate, toDate);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid ordersID, Guid userAccountID, string keyword, DateTime fromDate, DateTime toDate)
        {
            return OrdersDB.GetDataTable(ordersID, userAccountID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword), fromDate, toDate);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid ordersID, Guid userAccountID, string keyword, DateTime fromDate, DateTime toDate)
        {
            return OrdersDB.GetDataSet(ordersID, userAccountID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword), fromDate, toDate);
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(Orders myOrders)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                OrdersDB.Save(myOrders);
                int sequence = 1;
                if (myOrders.OrdersDetailsList != null)
                {
                    foreach (OrdersDetails myOrdersDetails in myOrders.OrdersDetailsList)
                    {
                        myOrdersDetails.Mode = myOrders.Mode;
                        myOrdersDetails.OrdersID = myOrders.UniqueID;
                        myOrdersDetails.SequenceNo = sequence++;
                        OrdersDetailsDB.Save(myOrdersDetails);
                    }
                }

                if (myOrders.OrdersPaymentList != null)
                {
                    foreach (OrdersPayment myPaymentDetails in myOrders.OrdersPaymentList)
                    {
                        myPaymentDetails.Mode = myOrders.Mode;
                        myPaymentDetails.OrdersID = myOrders.UniqueID;
                        OrdersPaymentDB.Save(myPaymentDetails);

                        //For OCBC Payments
                        if (myPaymentDetails.OCBCResponse != null)
                        {
                            myPaymentDetails.OCBCResponse.OrdersPaymentID = myPaymentDetails.UniqueID;
                            OCBCHelperDB.Save(myPaymentDetails.OCBCResponse);
                        }
                        //For Nets Payment 
                        if (myPaymentDetails.NETSResponse != null)
                        {
                            myPaymentDetails.NETSResponse.OrdersPaymentID = myPaymentDetails.UniqueID;
                            NETSHelperDB.Save(myPaymentDetails.NETSResponse);
                        }
                    }
                }

                myTransactionScope.Complete();
                return true;
            }
        }

        [DataObjectMethod(DataObjectMethodType.Delete, true)]
        public static bool Delete()
        {
            OrdersDetailsDB.Delete();
            OrdersDB.Delete();
            return true;
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool GenerateInvoice(Guid ordersID)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                OrdersDB.GenerateInvoice(ordersID);
                myTransactionScope.Complete();
                return true;
            }
        }

        //[DataObjectMethod(DataObjectMethodType.Update, true)]
        //public static bool GenerateDO(Guid ordersID)
        //{
        //    using (TransactionScope myTransactionScope = new TransactionScope())
        //    {
        //        OrdersDB.GenerateDO(ordersID);
        //        myTransactionScope.Complete();
        //        return true;
        //    }
        //}
    }
}
